//Dustin Soodak
//Behavior 051: testing x-tilt in navigation
//Testing algorithm for turning NavigationXY() to NavigationXYTilt()
//Appears to be drift in gyro x zero over period of several seconds.
//Also: x/y accel doesn't seem to be good indication of initial tilt.
#include "MiscHardware.h"
#include "Navigation.h"

//code to test NavigationXYTilt() functionality
extern int nav_data[3];//made global so compiler doesn't optimize it out of navigation functions
extern int nav_data2[3];
extern int nav_data3[3];
char gn,an,m,i,j;
int32_t N_accelxraw,N_accelyraw;
int32_t totals[3];
int Accel,AccelCorrection,AccelCorrectionRaw;

void ZeroNavigationTilt(void){
  char i,j;
  //Zero gyro all at once (old/normal way):
    Serial.println("wait then get gyro data all at once");
    for(i=0;i<3;i++)
      totals[i]=0;
    i=1000;
    while(GyroBufferSize()<30 && i)i--; 
    for(i=0;i<30;i++){
      GyroGetAxes(nav_data);
      for(j=0;j<3;j++){
        totals[j]+=nav_data[j];   
        //Serial.print(nav_data[j]);Serial.print("\t");     
      }
      //Serial.println();
    }
    for(i=0;i<3;i++){
      GyroZeroes[i]=totals[i]/30;
      Serial.print(GyroZeroes[i]);Serial.print("\t");
    }
    Serial.println();
   

    //Zero gyro as available (new/different way):
    Serial.println("get gyro data as it becomes available");
    for(i=0;i<3;i++)
      totals[i]=0;
    for(i=0;i<30;i++){
      while(GyroBufferSize()==0);
      GyroGetAxes(nav_data);          
      for(j=0;j<3;j++){  
        totals[j]+=nav_data[j];        
        //Serial.print(nav_data[j]);Serial.print("\t");     
      }        
      //Serial.println();      
    }
    for(i=0;i<3;i++){
      GyroZeroes[i]=totals[i]/30;
      Serial.print(GyroZeroes[i]);Serial.print("\t");
    }
    Serial.println();
    //
    
    
   
    //Accel average to find zero value (assuming not currently moving)
    for(i=0;i<3;i++)
      totals[i]=0;
    i=1000;
    while(AccelBufferSize()<20 && i)i--; 
    for(i=0;i<20;i++){
      AccelGetAxes(nav_data);
      for(j=0;j<3;j++){
        totals[j]+=nav_data[j];
      }
    }
    for(i=0;i<3;i++){
      AccelZeroes[i]=totals[i]/20;
      AccelVelocity[i]=0;//assumes it isn't moving when this function called
    }      
    //Zero sensors with arcsin:
    //9800*sin(GyroXRaw*((0.0000355*2000/380)*3.14159/180))=AccelYRaw*(-(float)(2*9800)/32768
    //9800*sin(GyroPosition[0]*((0.0000355*2000/380)*3.14159/180))=AccelZeroes[1]*(-(float)(2*9800)/32768
    //GyroPosition[0]=-arcsin(AccelZeroes[1]*((float)(2)/32768))/((0.0000355*2000/380)*3.14159/180)
    //Zero sensors with arctan:
    //atan2(x,y) (instead of y,x) so theta of 90 degrees -> 0 degrees.
    //GyroPosition[0]=-atan2(AccelZeroes[1],AccelZeroes[2])/((0.0000355*2000/380)*3.14159/180);
    //Calculate new:
    //Theta=GyroPosition[0]*((0.0000355*2000/380)*3.14159/180);
    //AccelOffsetRaw*2*9800/32768=9800*sin(Theta);//raw to mm/s^2 is ((float)(2*9800)/32768);
    //AccelAcceleration[1]-=sin(Theta)*16384;
    //Since sin(theta)=theta for small theta, just need one float and no trig:
    //AccelAcceleration[1]-=GyroPosition[0]*(((0.0000355*2000/380)*3.14159/180)*16384)
    //
    //For gyroX correction to accelY:
    GyroPosition[0]=-asin(AccelZeroes[1]*((float)(2)/32768))/((0.0000355*2000/380)*3.14159/180);
    
    //AccelCorrectionRaw=GyroPosition[0]*(((0.0000355*2000/380)*3.14159/180)*16384);
    //AccelCorrection=AccelCorrectionRaw*((float)(2*9800)/32768);
    
    //Acceleration
    Serial.println("Zeroed");
    Serial.print("yAccel=");
    Serial.print(-((float)(2*9800)/32768)*AccelZeroes[1],0);
    Serial.print("mm^2(");Serial.print(AccelZeroes[1],DEC);Serial.print(")");
    Serial.print("\r\nxGyro: ");
    Serial.print(GyroPosition[0]*((0.0000355*2000/380)),2);
    Serial.print("Deg(");
    Serial.print(GyroPosition[0],DEC);
    Serial.print(")");
    //Using degrees
    Accel=-AccelZeroes[1]*((float)(2*9800)/32768);
    AccelCorrectionRaw=GyroPosition[0]*(((0.0000355*2000/380)*3.14159/180)*16384);
    AccelCorrection=AccelCorrectionRaw*((float)(2*9800)/32768);
    Serial.print(" yAccelCorrection=");Serial.print(AccelCorrection,DEC);Serial.print("mm/s^2(");Serial.print(AccelCorrectionRaw,DEC);Serial.print(") ");
    Serial.println();
    Serial.print("gyro zero ");Serial.println(GyroZeroes[0]);
        
    //To check how accurate each step is:
    //Serial.print((float)GyroPosition[0],5);Serial.print("==");Serial.println(-asin(AccelZeroes[1]*((float)(2)/32768))/((0.0000355*2000/380)*3.14159/180),5);
    //Serial.print((float)GyroPosition[0]*((0.0000355*2000/380)*3.14159/180),10);Serial.print("==");Serial.println(-asin(AccelZeroes[1]*((float)(2)/32768)),10);
    //Serial.print(sin(-(float)GyroPosition[0]*((0.0000355*2000/380)*3.14159/180)),10);Serial.print("==");Serial.println(AccelZeroes[1]*((float)(2)/32768),10);
    //Serial.print(-(float)GyroPosition[0]*((0.0000355*2000/380)*3.14159/180),10);Serial.print("==");Serial.println(AccelZeroes[1]*((float)(2)/32768),10);
    //Serial.print(-(float)GyroPosition[0]*((0.0000355*2000/380)*3.14159/180)*16384,10);Serial.print("==");Serial.println(AccelZeroes[1],DEC);
       
    Serial.println();   
}
void NavigationTilt(void){
  char i,j;
  //This code used to upgrade NavigationXY() to  NavigationXYTilt():
  //It only includes the code necessary to do y-accel correction (not full x/y movement).
  gn=GyroBufferSize();              //Reads how many buffer positions are full in the Gyro (the Gyro has 32 buffer 
                                    //positions/readings and must be read prior to reaching 32 to avoid inaccurate calculation)
  an=AccelBufferSize();             //Reads how many buffer positions are full in the Accelerometer (the Accel has 32 buffer
                                    //positions/readings and must be read prior to reaching 32 to avoid inaccurate calculation)
  
  if(an>gn)                         //Because the accel reads 400 Hz and gryo reads 380 Hz, this section keeps them in sync by
    m=gn/(an-gn);                   //occasionally averaging 2 consecutive readings from the accel
  else
    m=99;        
  //digitalWrite(Light_Bus_BTN1,0);                               //<-- uncomment to spit values out the serial debug
  for(i=0;i<gn;i++){      
    GyroGetAxes(nav_data);            //380 hz       
    AccelGetAxes(nav_data2);          //400 hz
    //Serial.print(i);Serial.print(" ");Serial.print(gn);Serial.print(an);Serial.println(m,DEC);    //<-- uncomment to spit values out the serial debug
    if(((i+1)%m)==0){                 //to keep buffers in sync
       AccelGetAxes(nav_data3);
       for(j=0;j<3;j++){
          nav_data2[j]=(((int32_t)nav_data2[j])+nav_data3[j])/2;
       }
    }
    
    //add up gyro x-axis:
    GyroVelocity[0]=((nav_data[0]-GyroZeroes[0])); 
    GyroPosition[0]+=GyroVelocity[0]; 
    
    //do other 2 for comparison/debug:
    GyroVelocity[1]=((nav_data[1]-GyroZeroes[1])); 
    GyroPosition[1]+=GyroVelocity[1];
    GyroVelocity[2]=((nav_data[2]-GyroZeroes[2])); 
    GyroPosition[2]+=GyroVelocity[2];
    
    
   //3 options for testing:
    //regular zero-corrected y:
    //N_accelyraw=((int32_t)nav_data2[1])-AccelZeroes[1];//non-rotated value
    //rotation-corrected y:
    N_accelyraw=((int32_t)nav_data2[1])+GyroPosition[0]*(((0.0000355*2000/380)*3.14159/180)*16384);
    
    
  }//end for(i=0;i<gn;i++)
  if(gn>=31)
    Serial.println("overflow");
  
  Accel=-nav_data2[1]*((float)(2*9800)/32768);
  AccelCorrectionRaw=GyroPosition[0]*(((0.0000355*2000/380)*3.14159/180)*16384);
  AccelCorrection=AccelCorrectionRaw*((float)(2*9800)/32768); 
  
}


//Set motor speeds
char mode,ch;
int leftmotor=0,rightmotor=0;
String NumString;
void InputMotorSpeeds(void){
  char i;
//set motor speeds
  mode=0;//in this case, used for motor selection
  NumString="";
  Serial.println("enter left motor");
  while(1){
    if(Serial.available() > 0){
      ch = Serial.read();    
      if (isDigit(ch) || ch=='-'){        
        NumString += (char)ch;
      }
      if(ch=='\n'){
        if(NumString.length()<1){
          Serial.print("exit string length ");Serial.print(NumString.length(),DEC);
          for(i=0;i<NumString.length();i++){
            Serial.print(" ");Serial.print(NumString[i]);
          }
          Serial.println();
          break;//continue 
        }
        if(mode==0){
          leftmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter right motor");
          mode=1;
        }  
        else if(mode==1){
          rightmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter left motor");
          mode=0;
        }
        NumString="";
      }
    }//end if(Serial.available() > 0)
  }
  //end set motor speeds 
}

#define LENGTH 100
int data[LENGTH][2];
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  //This section lets you know when the robot restarts:
  PlayChirp(1000, 50);
  SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  PlayChirp(1000, 0);
  SwitchPixelsToButton();
  /*while(!ButtonPressed());
  delay(10);
  while(ButtonPressed());
  delay(1000);
  ExploreExample(180, 60*5, 500);
  while(1);*/
  
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();
  
  
  InputMotorSpeeds();
  
}


int t;
void loop(){ 
  
  SwitchPixelsToButton();
  if(ButtonPressed() || Serial.available()){//then zero sensors
    while(Serial.available())Serial.read();//clear serial buffer
      
    delayMicroseconds(1000);
    while(ButtonPressed());
    delay(1000);
    
    ZeroNavigationTilt();
    
    if(leftmotor!=0 || rightmotor!=0){
      SwitchSerialToMotors();
      Motors(leftmotor,rightmotor);
      i=0;
      RestartTimer();
      for(i=0;i<LENGTH;i++){
        while(!GyroBufferSize());
        NavigationTilt();        
        data[i][0]=nav_data2[1];//Y-Axis Acceleration (raw, un-zeroed)
        data[i][1]=GyroPosition[0];//X-Axis Gyroscope Sum (raw, zeroed)
      }      
      t=GetTime();
      Motors(0,0);
      while(!ButtonPressed());      
      SwitchMotorsToSerial();
      Serial.println("ms\tyAccelRaw\txGyroPosRaw");
      for(i=0;i<LENGTH;i++){
        Serial.print(i*((float)t)/LENGTH);Serial.print("\t");Serial.print(data[i][0],DEC);Serial.print("\t");Serial.println(data[i][1]);
      }     
    }//end if(leftmotor!=0 || rightmotor!=0)
    
      
  }//end if(ButtonPressed() || Serial.available()){//then zero sensors
 
  
  
  NavigationTilt();
  
  if(GetTime()>300){
    Serial.print("yAccel=");Serial.print(Accel,DEC);Serial.print("mm/s^2(");Serial.print(nav_data2[1],DEC);Serial.print(") ");
    Serial.print(" xGyro=");Serial.print((float)GyroPosition[0]*((0.0000355*2000/380)),2);Serial.print("Deg(");Serial.print(GyroPosition[1],DEC);Serial.print(")");  
    Serial.print(" yAccelCorrection=");Serial.print(AccelCorrection,DEC);Serial.print("mm/s^2(");Serial.print(AccelCorrectionRaw,DEC);Serial.print(") ");
    Serial.print(" xyzGyroRaw\t");Serial.print(nav_data[0]);
    Serial.print("\t");Serial.print(nav_data[1]);
    Serial.print("\t");Serial.print(nav_data[2]);
    
    Serial.println();
    RestartTimer();
  } 
  
}
